/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)69	1.42  src/avs/fs/mmfs/ts/DirIds.h, mmfs, avs_remp, rempt1d1 7/16/01 23:02:26 */
#ifndef _h_DirIds
#define _h_DirIds

/*
 * Define unique numeric IDs for each source directory in Shark that contains
 * code.  These directory IDs are used for several purposes:
 *   1. Generating unique labels ("hookids") for kernel trace points
 *   2. Identifying message set numbers for the message catalog code
 * The symbols defined in this file are formed by appending the relative
 * directory name to the string "DIR_ID_", then translating slashes to
 * underscores.
 *   The values of the directory IDs must be in the range 1...63:
 * zero is not allowed because 0 is not valid as a message set number;
 * values larger than 63 cannot be used because only 6 bits of the ID are
 * used in generating kernel trace hookids.
 *
 * ======================================================================
 *
 * DO NOT renumber these IDs, or reuse an ID for a directory that
 * has been deleted, as numbers derived from these IDs appear in the
 * message catalog and trace format file.
 *
 * The message files are listed here with their message number ranges.
 * The range of numbers of MMFS messages 3-digit codes
 * reserved for each existing message catalog file (.msg file)
 *
 * The messages displayed have the format "GPFS: 6027-xxx <message text>"
 * where xxx is the unique 3-digit or 4-digit code for the particular error.
 *
 *
 *
 * SUBDIRECTORY            CATALOG FILE NAME                RANGE OF CODES
 * ------------            -----------------                --------------
 *                                                    unused    000-149
 *  install                 install.msg             SMIT msgs   150-299
 *  mmfsd                     mmfsd.msg                         300-309
 *  tasking (1)                task.msg                         310-339
 *  classes/tscomm           tscomm.msg                         340-359
 *  disk (1)                   disk.msg                         360-379
 *  classes/basic              base.msg                         380-399
 *  stripe                   stripe.msg                         400-499
 *  vfs                        svfs.msg                         500-529
 *  fs                           fs.msg                         530-599
 *  cfgmgr (1)                 cfgm.msg                         600-649
 *  logger                   logger.msg                         650-659
 *  cfgmgr (2)                 cfgm.msg                         660-749
 *  phoenix (1)             phoenix.msg                         800-849
 *  util                       util.msg                         850-999
 *  admin                     admin.msg                        1000-1399
 *  log                         log.msg                        1400-1449
 *  defrag                   defrag.msg                        1450-1499
 *  disk (2)                   disk.msg                        1500-1529
 *  tasking (2)                task.msg                        1530-1549
 *  admin (2)                 admin.msg                        1550-1699
 *  classes/tscomm (2)       tscomm.msg                        1700-1799
 *  nsd                         nsd.msg                        1800-1849
 *  phoenix (2)             phoenix.msg                        1850-1899
 *
 * ======================================================================
 *
 * $Id: DirIds.h,v 1.65 2001/07/16 20:08:00 radhak Exp $
 *
 * $Log: DirIds.h,v $
 * Revision 1.65  2001/07/16 20:08:00  radhak
 * Defect 343890: Added NLS translations to the new messages added for the
 * fix to defect 342755.
 *
 * Also, added code to bypass adapter subscription in a single node env.
 *
 * Revision 1.64  2001/05/06 20:25:53  jpalmer
 * Enable TRACE_NSS tracing
 *
 * Revision 1.63  2001/02/02 16:16:12  esj
 * Define a range for nsd message catalog (comment change only).
 *
 * Revision 1.62  2000/10/26  01:07:16  tee
 * Put back SHARKHOOKID definitions since mktrace uses them to get the
 * hookid to put in the trclst file.
 *
 * Revision 1.61  2000/10/25 16:25:42  wyllie
 * Trace include reorganization: split old tasking/Trace.h into five new
 * files, and move most of them into directories that will be shipped with
 * GPFS on Linux.  Also change the code in trcid.h files generated by
 * mktrace to not include AIX specific stuff like direct use of AIX trace
 * macros.  Change names of all macros in generated code to have a leading
 * underscore.  As a result of these changes, all trcid.h files had to
 * be rebuilt.
 *
 * Revision 1.60  2000/10/20  14:24:33  gjertsen
 * First iteration in splitting shared segment code to prepare for
 * AIX 5X and clean up #ifdef mess some. Add new platform directories.
 *
 * Revision 1.59  2000/08/29  17:32:07  andreye
 * Add new DIR_IDs for ts/logger/linux and ts/logger/aix.
 *
 * Revision 1.58  2000/08/07  22:26:25  tee
 * Add new directory ID for NSD
 *
 * Revision 1.57  2000/07/28 23:26:28  eshel
 * add trcid for new directories
 *
 * Revision 1.56  2000/07/12  16:22:48  dcraft
 * Remove old fsck
 *
 * Revision 1.55  2000/06/28  19:34:45  dcraft
 * Remove struct ucred and cred.h dependencies from all OS
 * independent code.  Consistently use cxiUid_t and cxiGid_t.
 * Add linux, aix directories to ts/fs for system dependent code.
 * No-op entry points to DFS export code to avoid ifdefs.
 *
 * Revision 1.54  2000/06/06  19:54:09  dixonbp
 * Add a new DIR_ID for the kernext/aix subdirectory and include its
 * trace points in mmfs.trclst.
 *
 * Revision 1.53  2000/05/18  21:04:55  wyllie
 * Rename kernext/freelinux to kernext/gpl-linux.  Change still needed in
 * mktrace to handle the hyphen.
 *
 * Revision 1.52  2000/05/15  18:18:38  eshel
 * add new directory id
 *
 * Revision 1.51  2000/03/30  18:16:47  schmuck
 * Move definitions of SHARKHOOKID overrides from local trcid.h files
 * into DirIds.h, where they won't be lost when a trcid.h file is re-built
 * from scratch.
 *
 * Revision 1.50  2000/01/11  20:24:52  eshel
 * LINUX update.
 *
 * Revision 1.49  1999/09/03  20:11:27  kywang
 * Allocate additional message range 1600-1699 to tscomm.
 *
 * Revision 1.48  1999/09/03 20:07:16  dcraft
 * Add pfsck to directory list (ifdef'd)
 *
 * Revision 1.47  1999/08/28  16:59:22  esj
 * Comment changes: Reserve new range of message numbers for admin.msg.
 *                  Document change of field separator for tsctl QuorumState
 *
 * Revision 1.46  1999/07/14  22:23:49  dcraft
 * Remove DFSEXPORT and DFSACL ifdefs
 *
 * Revision 1.45  1999/06/18  06:34:32  mcnabb
 * Rearrange newest DIR_IDs
 *
 * Revision 1.44  1999/06/17  16:23:48  romano
 * Add message based perf. mon. class.
 *
 * Revision 1.43  1999/01/14  19:53:25  esj
 * Comment change only: assign new range of message numbers for task.msg
 *
 * Revision 1.42  1998/12/07  19:21:18  mcnabb
 * DIR_ID_FS is about to overflow its 1024 traces.
 * Reserve next DIR_ID so that it can use the next 1024 traces for new ones.
 * This requires moving DIR_ID_FSCK so its traces and msg catalog ID change.
 *
 * Revision 1.41  1998/09/03  17:48:21  curran
 * Allocate message range 1500-1529 to disk. Some disk messages have overlaid
 * base messages.
 *
 * Revision 1.40  1998/06/08  19:38:17  kywang
 * -DDEFRAG: tsdefragfs initial code drop.
 *
 * Revision 1.39  1998/04/24  20:25:36  schmuck
 * Remove old check-in comments and obsolete copyright notice.
 *
 * [ 34 log messages deleted ]
 *
 * Revision 1.1  1993/07/16  18:09:11  wyllie
 * Add file with unique IDs for each Shark source code directory.
 *
 */

/*
 * IMPORTANT (see also comments at the top of this file):
 *  - names must be of the form DIR_ID_XXX, where XXX = relative dir name
 *  - values must be in the range 1 ... 63
 */
#define DIR_ID_CFGMGR                   1
#define DIR_ID_CLASSES_BASIC            2
#define DIR_ID_CLASSES_MALLOC           3
#define DIR_ID_LOCKMGR                  4
#define DIR_ID_CLASSES_TSCOMM           5
#define DIR_ID_DEBUG                    6
#define DIR_ID_DISK                     7
#define DIR_ID_FS                       8
/*#define DIR_ID_FS_OVERFLOW do not reuse 9*/
/* unused                               10 */
#define DIR_ID_INSTALL                  11
#define DIR_ID_LOGGER                   12
#define DIR_ID_MMFSD                    13
#define DIR_ID_ADMIN                    14
#define DIR_ID_PAGEMGR                  15
/*#define DIR_ID_PIPELINE                 16 */
/*#define DIR_ID_RPC                      17 */
#define DIR_ID_TASKING                  18
#define DIR_ID_VFS                      19
#define DIR_ID_KERNEXT                  20
/*#define DIR_ID_TESTAPPS_MPEG            21 */
/*#define DIR_ID_TESTAPPS_SHPLAYER        22 */
/*#define DIR_ID_TESTAPPS_TEST            23 */
/*#define DIR_ID_TESTAPPS_TESTPP          24 */
#define DIR_ID_LOG                      25
#define DIR_ID_CLASSES_PERFMON          26
#define DIR_ID_UTIL                     27
#define DIR_ID_STRIPE                   28
/*#define DIR_ID_CATMNT                         29 */
#define DIR_ID_PHOENIX                  30
#define DIR_ID_UTIL_SCRIPT              31
#define DIR_ID_ADMIN_SCRIPT             32
#define DIR_ID_TM                       33
#define DIR_ID_DM                       34
#define DIR_ID_DM_KX                    35
#define DIR_ID_DEFRAG                   36
#define DIR_ID_CLASSES_MBPERFMON        37
#define DIR_ID_PFSCK                    38
#define DIR_ID_DIRLINUX                 39
#define DIR_ID_KERNEXT_GPL_LINUX        40
#define DIR_ID_KERNEXT_AIX              41
#define DIR_ID_FS_AIX                   42
#define DIR_ID_FS_LINUX                 43
#define DIR_ID_KERNEXT_GPL_LINUX_I386   44
#define DIR_ID_KERNEXT_GPL_LINUX_IA64   45
#define DIR_ID_NSD                      46
#define DIR_ID_LOGGER_AIX               47
#define DIR_ID_LOGGER_LINUX             48
#define DIR_ID_KERNEXT_LINUX            49
#define DIR_ID_TASKING_AIX              50
#define DIR_ID_TASKING_LINUX            51
#define DIR_ID_NSS                      52


/* Add new directory IDs above here */

/* 91 is being used for SMIT help */

/* overrides for default hookid (307) in certain directories */
#define SHARKHOOKID_TM      0x30600000
#define SHARKHOOKID_TASKING 0x30800000
#define SHARKHOOKID_KERNEXT 0x30900000

#endif  /* _h_DirIds */
